IF OBJECT_ID('P_EXP_CTB_MOV_CHQ_DEST_ENV') IS NOT NULL
	BEGIN
		DROP PROCEDURE P_EXP_CTB_MOV_CHQ_DEST_ENV
	END
 
GO 
 
 
CREATE PROCEDURE P_EXP_CTB_MOV_CHQ_DEST_ENV(@CD_EMP			INT,
											@CD_FILIAL		INT,
											@DT_INI			DATETIME,
											@DT_FIM			DATETIME,
											@FLAG_LIMPAR	INT = 0)		
	
WITH ENCRYPTION AS 
SET NOCOUNT ON;
BEGIN TRY
BEGIN
	DECLARE @RS_CD_EMP					INT
	DECLARE @RS_CD_FILIAL				INT
	DECLARE @RS_CD_CNT_ORIG 			INT
	DECLARE @RS_NR_CHQ					INT 
	DECLARE @RS_SR_CHQ					VARCHAR(2)
	DECLARE @RS_ANO_CHQ					INT
	DECLARE @RS_VLR_CHQ					MONEY
	DECLARE @RS_VLR_JUROS				MONEY
	DECLARE @RS_VLR_DESP				MONEY
	DECLARE @RS_DT_ENV					DATETIME

	DECLARE @RET_CD_CTB_CNT				VARCHAR(100)
	DECLARE @RET_CD_CTB_CNT_RED			INT	
	DECLARE @RET_DS_CNT					VARCHAR(100)
	DECLARE @RET_NR_CNT					VARCHAR(50)
	DECLARE @RET_TP_CNT					INT
	DECLARE @RET_TITULAR_CNT			     VARCHAR(200)
	DECLARE @HIST						VARCHAR(200)
	DECLARE @NR_CONTROLE                    VARCHAR (12)
	DECLARE @RS_CD_CHQ					INT

	
	------------------------------------------------------------------------------------------------------------------------------
	--CRIANDO A TABELA TEMPORARIA ##CTB_EXP_MOV
	------------------------------------------------------------------------------------------------------------------------------
	EXEC P_EXP_CTB_MOV_CRIAR_CTB_EXP_MOV @FLAG_LIMPAR
	
	DECLARE RS_RESULT
	CURSOR FOR 	
		SELECT	
			CD_EMP					,
			CD_FILIAL				,
			CD_CNT_ORIG 			,
			NR_CHQ					,
			SR_CHQ					,
			ANO_CHQ					,
			VLR_CHQ					,
			VLR_JUROS				,
			VLR_DESP				,
			DT_ENV,
			CD_CHQ					
    
	    FROM UFD_EXP_CTB_MOV_CHQ_DEST_ENV(@CD_EMP, @CD_FILIAL, @DT_INI, @DT_FIM)
		--select * FROM UFD_EXP_CTB_MOV_CHQ_DEST_ENV(1, 1, '20240801', '20240801')
		ORDER BY
			CD_EMP					,
			CD_FILIAL				,
			DT_ENV
									
		--Abrindo cursor
		OPEN RS_RESULT
		
		--Atribuindo valores do select nas variveis
		FETCH NEXT FROM RS_RESULT INTO 
				@RS_CD_EMP					,
				@RS_CD_FILIAL				,
				@RS_CD_CNT_ORIG 			,
				@RS_NR_CHQ					,
				@RS_SR_CHQ					,
				@RS_ANO_CHQ					,
				@RS_VLR_CHQ					,
				@RS_VLR_JUROS				,
				@RS_VLR_DESP				,
				@RS_DT_ENV,
				@RS_CD_CHQ							
					 

		--Iniciando lao
		WHILE @@FETCH_STATUS = 0
			BEGIN	
				
				IF @RS_VLR_CHQ > 0 
					BEGIN 

						SELECT 							
							@RET_CD_CTB_CNT			= CD_CTB_CNT,
							@RET_CD_CTB_CNT_RED		= CD_CTB_CNT_RED,
							@RET_DS_CNT				= DS_CNT,
							@RET_NR_CNT				= NR_CNT,
							@RET_TP_CNT				= TP_CNT,
							@RET_TITULAR_CNT		= TITULAR_CNT
						FROM UFD_BUSCA_CONTA_BC_CONTAS(@CD_EMP, @RS_CD_CNT_ORIG)
						
						SET @HIST = 'ENVIO DE CHEQUE DEVOLVIDO PARA COBRANCA N. ' + CAST(@RS_NR_CHQ AS VARCHAR) + ' - SERIE: ' + CAST(@RS_SR_CHQ AS VARCHAR) + ' ANO: ' + CAST(@RS_ANO_CHQ AS VARCHAR) + ' CONTA ORIGEM DEPOSITO: ' + @RET_DS_CNT + ' - ' + @RET_NR_CNT
						SET @HIST = REPLACE (@HIST,'	',' ')
						SET @NR_CONTROLE = RIGHT('00000000'+ CAST(@RS_CD_CHQ AS VARCHAR),8)  + '24'
						
						------------------------------------------------------------------------------------------------------------------
						--ENVIO.CHQ.COBRANA - CREDITO -  CONTA BANCO
						------------------------------------------------------------------------------------------------------------------
						INSERT INTO ##CTB_EXP_MOV  

                                          (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
										  CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
										  VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
										  ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

							SELECT		@RS_CD_EMP										    AS CD_EMP,
									    @RS_CD_FILIAL								        AS CD_FILIAL,
										@CD_FILIAL										    AS CD_FILIAL_EXPORT,
										24												    AS CD_MOVIMENTO,
										'CHEQUE - ENVIO DE CHEQUE DEVOLVIDO PARA COBRANCA'	AS MOVIMENTO,
										'ENVIO.CHQ.COBRANCA'							    AS OPERACAO,
										''												    AS OPERACAO_DEBITO,
										@RET_CD_CTB_CNT_RED								    AS CD_CNT_RED_CREDITO,
										@RET_CD_CTB_CNT									    AS CD_CNT_CREDITO,
										0												    AS CD_CNT_RED_DEBITO,
										''												    AS CD_CNT_DEBITO,																					
										@RS_DT_ENV										    AS DT_MOV,																						
										@HIST 											    AS HIST,								
										@RS_VLR_CHQ										    AS VLR_LANC,
										'C'												    AS TP_TRANSA,
										0 												    AS RATEIO_CENTRO_CUSTO,
										'' 												    AS DS_CENTRO_CUSTO,
										0 												    AS CNT_CENTRO_CUSTO,
										0 												    AS VLR_CENTRO_CUSTO,
										--'CNT BANC'										AS ORIG_CONTA,
										--@RS_CD_CNT_ORIG								    AS COD_CONTA,
										'FILIAIS'                                           AS ORIG_CONTA,
										20          									    AS COD_CONTA,
										OBJECT_NAME(@@PROCID)							    AS NM_PROCEDURE
										,'T' AS TIPO_LANCTO
										, 0 AS CD_EVENTO
										, 0  AS NR_DP
										, 0  AS ANO
										, @NR_CONTROLE AS NR_DOC
										, '' AS CD_BC_LANC;	
										
						------------------------------------------------------------------------------------------------------------------
						--ENVIO.CHQ.COBRANA - DEBITO -  Ctb_Cnt_Cheques_Recebimento_Tesouraria
						------------------------------------------------------------------------------------------------------------------
						INSERT INTO ##CTB_EXP_MOV  
					
                                        (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
										  CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
										  VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
										  ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

							SELECT		@RS_CD_EMP										     AS CD_EMP,
									    @RS_CD_FILIAL									     AS CD_FILIAL,
										@CD_FILIAL										     AS CD_FILIAL_EXPORT,
										24												     AS CD_MOVIMENTO,
										'CHEQUE - ENVIO DE CHEQUE DEVOLVIDO PARA COBRANCA'	 AS MOVIMENTO,
										''												     AS OPERACAO,
										'ENVIO.CHQ.COBRANCA'							     AS OPERACAO_DEBITO,
										0												     AS CD_CNT_RED_CREDITO,
										''												     AS CD_CNT_CREDITO,
										0												     AS CD_CNT_RED_DEBITO,
										''												     AS CD_CNT_DEBITO,																					
										@RS_DT_ENV										     AS DT_MOV,																						
										@HIST 											     AS HIST,								
										@RS_VLR_CHQ										     AS VLR_LANC,
										'D'												     AS TP_TRANSA,
										0 												     AS RATEIO_CENTRO_CUSTO,
										'' 												     AS DS_CENTRO_CUSTO,
										0 												     AS CNT_CENTRO_CUSTO,
										0 												     AS VLR_CENTRO_CUSTO,
										'FILIAIS'										     AS ORIG_CONTA,
										19												     AS COD_CONTA,
										OBJECT_NAME(@@PROCID)							     AS NM_PROCEDURE
									   , 'T' AS TIPO_LANCTO
									   , 0 AS CD_EVENTO
									   , 0  AS NR_DP
									   , 0  AS ANO
									   , @NR_CONTROLE AS NR_DOC
									   , '' AS CD_BC_LANC;	
	
					END							
										

				------------------------------------------------------------------------------------------------------------------
				--Prximo registro				
				------------------------------------------------------------------------------------------------------------------
				--Atribuindo valores do select nas variveis
				FETCH NEXT FROM RS_RESULT INTO 
					@RS_CD_EMP					,
					@RS_CD_FILIAL				,
					@RS_CD_CNT_ORIG 			,
					@RS_NR_CHQ					,
					@RS_SR_CHQ					,
					@RS_ANO_CHQ					,
					@RS_VLR_CHQ					,
					@RS_VLR_JUROS				,
					@RS_VLR_DESP				,
					@RS_DT_ENV,
					@RS_CD_CHQ															

			END
		
		CLOSE RS_RESULT
		DEALLOCATE RS_RESULT	
		
END

END TRY
BEGIN CATCH
	CLOSE RS_RESULT
	DEALLOCATE RS_RESULT	

	INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
		SELECT
			ERROR_NUMBER() AS numero,
			ERROR_SEVERITY() AS severidade,
			ERROR_STATE() AS estado,
			ERROR_PROCEDURE() AS rotina,
			ERROR_LINE() AS linha,
			ERROR_MESSAGE() AS mensagem,
			GETDATE() AS dtErro;	
END CATCH					
  